<?php
include("db.php"); // Include your database connection

// Start the session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Use a default/guest ID if not logged in. For production, you should ensure a user is always logged in.
$user_id = $_SESSION['user_id'] ?? 1;

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
    exit();
}

// Read and decode the JSON data
$rawData = file_get_contents('php://input');
$data = json_decode($rawData, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
    exit();
}

// --- Data Validation and Sanitization ---
if (!isset($data['Product_name']) || empty(trim($data['Product_name'])) || !isset($data['MRP'])) {
    echo json_encode(['status' => 'error', 'message' => 'Product Name and MRP are required fields.']);
    exit();
}

// --- Assign, Sanitize, and Cast All Variables ---
$productId = isset($data['Product_id']) && !empty($data['Product_id']) ? (int)$data['Product_id'] : null;

// Strings that need escaping
$productName = mysqli_real_escape_string($conn, $data['Product_name']);
$variant = isset($data['Variant']) ? mysqli_real_escape_string($conn, $data['Variant']) : '';
$display = isset($data['display']) ? mysqli_real_escape_string($conn, $data['display']) : '';
$productDescription = isset($data['Product_description']) ? mysqli_real_escape_string($conn, $data['Product_description']) : '';
$hsn = isset($data['HSN']) ? mysqli_real_escape_string($conn, $data['HSN']) : '';
$category = isset($data['category']) ? mysqli_real_escape_string($conn, $data['category']) : '';
$shape = isset($data['shape']) ? mysqli_real_escape_string($conn, $data['shape']) : '';
$wallthickness = isset($data['wallthickness']) ? mysqli_real_escape_string($conn, $data['wallthickness']) : '';
$outerdiameter = isset($data['outerdiameter']) ? mysqli_real_escape_string($conn, $data['outerdiameter']) : '';
$height = isset($data['height']) ? mysqli_real_escape_string($conn, $data['height']) : '';
$width = isset($data['width']) ? mysqli_real_escape_string($conn, $data['width']) : '';
$locationRack = isset($data['Location_rack']) ? mysqli_real_escape_string($conn, $data['Location_rack']) : '';
$brand = isset($data['Brand']) ? mysqli_real_escape_string($conn, $data['Brand']) : '';
$youtubeUrl = isset($data['Youtube_url']) ? mysqli_real_escape_string($conn, $data['Youtube_url']) : '';
$barcode = isset($data['barcode']) ? mysqli_real_escape_string($conn, $data['barcode']) : '';
$mUnit = isset($data['M_unit']) ? mysqli_real_escape_string($conn, $data['M_unit']) : 'kg';
$packingDate = isset($data['Packing_date']) && !empty($data['Packing_date']) ? mysqli_real_escape_string($conn, $data['Packing_date']) : null;
$expiryDate = isset($data['Expiry_date']) && !empty($data['Expiry_date']) ? mysqli_real_escape_string($conn, $data['Expiry_date']) : null;

// Numeric values that need casting
$mrp = (float)$data['MRP'];
$priceType = isset($data['Price_type']) ? (int)$data['Price_type'] : 1;
$taxPercentage = isset($data['Tax_percentage']) ? (float)$data['Tax_percentage'] : 5;
$purchasePrice = isset($data['Purchase_price']) ? (float)$data['Purchase_price'] : 0;
$qty = isset($data['qty']) ? (int)$data['qty'] : 0;
$minQty = isset($data['minqty']) ? (int)$data['minqty'] : 0;
$maxQty = isset($data['maxqty']) ? (int)$data['maxqty'] : 5;
$shippingWeight = isset($data['Shipping_weight']) ? (float)$data['Shipping_weight'] : 0;
$ParantId = isset($data['parantid']) ? (int)($data['parantid']) : 1;
$mode = isset($data['mode']) ? (int)$data['mode'] : 0;
$salePriceTax = isset($data['Sale_price_tax']) ? (int)$data['Sale_price_tax'] : 1;
$purchasePriceTax = isset($data['Purchase_price_tax']) ? (int)$data['Purchase_price_tax'] : 1;

// --- Calculations ---
$price = 0; $taxValue = 0; $sellingPrice = 0;
if ($priceType == 1) { // Inclusive
    $sellingPrice = (float)($data['Selling_price'] ?? 0);
    $price = $sellingPrice / (1 + ($taxPercentage / 100));
    $taxValue = $sellingPrice - $price;
} elseif ($priceType == 2) { // Exclusive
    $price = (float)($data['price'] ?? 0);
    $taxValue = $price * ($taxPercentage / 100);
    $sellingPrice = $price + $taxValue;
}
$discountValue = ($mrp > 0) ? $mrp - $sellingPrice : 0;
$discountPercentage = ($mrp > 0 && $discountValue > 0) ? (($discountValue / $mrp) * 100) : 0;
$quantity = ($mUnit == 'ton') ? $qty * 1000 : $qty;

// --- Handle Image Uploads ---
$productImages = [];
$mainProductImage = '';
if (isset($data['Product_images']) && is_array($data['Product_images'])) {
    foreach ($data['Product_images'] as $imageData) {
        if (empty($imageData)) continue;
        $imageData = preg_replace('/^data:image\/\w+;base64,/', '', $imageData);
        $decodedImage = base64_decode($imageData);
        if ($decodedImage === false) continue;

        $imageName = uniqid('', true) . '.png';
        $imagePath = 'images/' . $imageName;
        // Ensure the images directory exists and is writable
        if (!is_dir('images')) { mkdir('images', 0755, true); }
        if (file_put_contents($imagePath, $decodedImage)) {
            $fullUrl = 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/' . $imagePath;
            $productImages[] = mysqli_real_escape_string($conn, $fullUrl); // Escape the URL for safety
        }
    }
}
if (!empty($productImages)) {
    $mainProductImage = $productImages[0];
}


// --- Database Operation ---
if ($productId) {
    // ======== UPDATE EXISTING PRODUCT ========
    $update_parts = [];
    $update_parts[] = "Product_name = '$productName'";
    $update_parts[] = "Purchase_price = $purchasePrice";
    $update_parts[] = "MRP = $mrp";
    $update_parts[] = "Selling_price = $sellingPrice";
    $update_parts[] = "price = $price";
    $update_parts[] = "category = '$category'";
    $update_parts[] = "Variant = '$variant'";
    $update_parts[] = "displayplace = '$display'";
    $update_parts[] = "Product_description = '$productDescription'";
    $update_parts[] = "M_unit = '$mUnit'";
    $update_parts[] = "HSN = '$hsn'";
    $update_parts[] = "qty = $quantity";
    $update_parts[] = "Price_type = $priceType";
    $update_parts[] = "Sale_price_tax = $salePriceTax";
    $update_parts[] = "Purchase_price_tax = $purchasePriceTax";
    $update_parts[] = "Shipping_weight = $shippingWeight";
    $update_parts[] = "Tax_percentage = $taxPercentage";
    $update_parts[] = "tax = $taxValue";
    $update_parts[] = "Discount_percentage = $discountPercentage";
    $update_parts[] = "Discount_value = $discountValue";
    $update_parts[] = "Packing_date = " . ($packingDate ? "'$packingDate'" : "NULL");
    $update_parts[] = "Expiry_date = " . ($expiryDate ? "'$expiryDate'" : "NULL");
    $update_parts[] = "Location_rack = '$locationRack'";
    $update_parts[] = "Brand = '$brand'";
    $update_parts[] = "Youtube_url = '$youtubeUrl'";
    $update_parts[] = "barcode = '$barcode'";
    $update_parts[] = "minqty = $minQty";
    $update_parts[] = "maxqty = $maxQty";
    $update_parts[] = "mode = $mode";
    $update_parts[] = "Edit_id = $user_id";

    // Conditionally update product image only if a new one was uploaded
    if (!empty($mainProductImage)) {
        $update_parts[] = "Product_image = '$mainProductImage'";
    }

    $sql = "UPDATE product SET " . implode(', ', $update_parts) . " WHERE product_id = $productId";

    if ($conn->query($sql) === TRUE) {
        // If new images were uploaded, replace the old ones in the productimage table
        if (!empty($productImages)) {
            $conn->query("DELETE FROM productimage WHERE product_id = $productId");
            foreach ($productImages as $image_url) {
                $conn->query("INSERT INTO productimage (product_id, product_image) VALUES ($productId, '$image_url')");
            }
        }
        echo json_encode(['status' => 'success', 'message' => 'Product updated successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update product', 'error_detail' => $conn->error]);
    }

} else {
    // ======== INSERT NEW PRODUCT ========
    $result = $conn->query("SELECT SKU FROM product ORDER BY SKU DESC LIMIT 1");
    $lastSKU = ($result->num_rows > 0) ? $result->fetch_assoc()['SKU'] : 'SKU-0000';
    $newSKU = 'SKU-' . str_pad((int) substr($lastSKU, 4) + 1, 4, '0', STR_PAD_LEFT);

    // Handle NULL values for dates in the query string
    $packingDateValue = $packingDate ? "'$packingDate'" : "NULL";
    $expiryDateValue = $expiryDate ? "'$expiryDate'" : "NULL";

    $sql = "INSERT INTO product (Product_name, Purchase_price, MRP, Selling_price, price, category, Variant, displayplace, Product_description, M_unit, HSN, SKU, qty, Price_type, Sale_price_tax, Purchase_price_tax, Shipping_weight, Tax_percentage, tax, Discount_percentage, Discount_value, Packing_date, Expiry_date, Location_rack, Brand, Youtube_url, barcode, minqty, maxqty, mode, Creater_id, Edit_id, parantid, Product_image) 
            VALUES (
                '$productName', $purchasePrice, $mrp, $sellingPrice, $price, '$category', '$variant', '$display', '$productDescription', 
                '$mUnit', '$hsn', '$newSKU', $quantity, $priceType, $salePriceTax, 
                $purchasePriceTax, $shippingWeight, $taxPercentage, $taxValue, 
                $discountPercentage, $discountValue, $packingDateValue, $expiryDateValue, '$locationRack', '$brand', '$youtubeUrl', 
                '$barcode', $minQty, $maxQty, $mode, $user_id, $user_id, $ParantId, '$mainProductImage'
            )";

    if ($conn->query($sql) === TRUE) {
        $productId = $conn->insert_id;
        // Insert all images into the productimage table
        if (!empty($productImages)) {
            foreach ($productImages as $image_url) {
                $conn->query("INSERT INTO productimage (product_id, product_image) VALUES ($productId, '$image_url')");
            }
        }
        echo json_encode(['status' => 'success', 'message' => 'Product added successfully', 'product_id' => $productId]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to insert product', 'error_detail' => $conn->error]);
    }
}

$conn->close();
?>